// VcExampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VcExample.h"
#include "VcExampleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVcExampleDlg dialog

CVcExampleDlg::CVcExampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVcExampleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVcExampleDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVcExampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVcExampleDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVcExampleDlg, CDialog)
	//{{AFX_MSG_MAP(CVcExampleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_InitializeDevicesBUTTON, OnInitializeDevicesBUTTON)
	ON_BN_CLICKED(IDC_OPENDEVICE_BUTTON, OnOpendeviceButton)
	ON_BN_CLICKED(IDC_GETSERIALNO_BUTTON, OnGetserialnoButton)
	ON_BN_CLICKED(IDC_CHANNELNUM_BUTTON, OnChannelnumButton)
	ON_BN_CLICKED(IDC_SETNORMAL_BUTTON, OnSetnormalButton)
	ON_BN_CLICKED(IDC_TRIGGERPARA_BUTTON, OnTriggerparaButton)
	ON_BN_CLICKED(IDC_SETMODE_BUTTON, OnSetmodeButton)
	ON_BN_CLICKED(IDC_Follower_BUTTON, OnFollowerBUTTON)
	ON_BN_CLICKED(IDC_RestDevice_BUTTON, OnRestDeviceBUTTON)
	ON_BN_CLICKED(IDC_StorePara_BUTTON, OnStoreParaBUTTON)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVcExampleDlg message handlers

BOOL CVcExampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	DevHandle = -1;
	SetDlgItemText(IDC_CURRENTCHANNEL_EDIT, "1" );
	
	SetDlgItemText(IDC_NORMALMAX_EDIT, "200" );
	SetDlgItemText(IDC_NORMALSET_EDIT, "10" );
	SetDlgItemText(IDC_STROBEMAX_EDIT, "1000" );
	SetDlgItemText(IDC_STROBEREPEAT_EDIT, "100" );
	SetDlgItemText(IDC_TRIGGERMAX_EDIT, "1000" );
	SetDlgItemText(IDC_TRIGGERPOLARITY_EDIT, "1" );

	((CButton*)GetDlgItem(IDC_DISABLE_RADIO))->SetCheck(1);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVcExampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVcExampleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVcExampleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVcExampleDlg::OnOK() 
{
	// TODO: Add extra validation here
	if ( DevHandle != -1 )
		MTUSB_BLSDriverCloseDevice( DevHandle );
	CDialog::OnOK();
}

void CVcExampleDlg::OnInitializeDevicesBUTTON() 
{
	int USBDevices;
	CString MyStr;

	// TODO: Add your control notification handler code here
	USBDevices = MTUSB_BLSDriverInitDevices();
	MyStr.Format( "%d", USBDevices );
	SetDlgItemText(IDC_TOTALDEVICE_STATIC, MyStr );
}

void CVcExampleDlg::OnOpendeviceButton() 
{
	// TODO: Add your control notification handler code here
	DevHandle = MTUSB_BLSDriverOpenDevice(0);
	if ( DevHandle == -1  )
	{
		MessageBox(" Device Open Failed! ");
	}
}


void CVcExampleDlg::OnGetserialnoButton() 
{
	unsigned char SerialNum[32];
	// TODO: Add your control notification handler code here
	MTUSB_BLSDriverGetSerialNo( DevHandle, SerialNum, 32 );
	SetDlgItemText(IDC_SERIALNO_STATIC, CString( SerialNum ) );
}

void CVcExampleDlg::OnChannelnumButton() 
{
	int Channels;
	CString MyStr;
	// TODO: Add your control notification handler code here
	Channels = MTUSB_BLSDriverGetChannels( DevHandle );
	MyStr.Format( "%d", Channels );
	SetDlgItemText(IDC_CHANNELNO_STATIC, MyStr );
}

void CVcExampleDlg::OnSetnormalButton() 
{
	int Iset;
	int CurrentChannel;
	CString cs;

	// TODO: Add your control notification handler code here
	GetDlgItemText(IDC_CURRENTCHANNEL_EDIT, cs);
	sscanf(cs, "%i", &CurrentChannel);

	GetDlgItemText(IDC_NORMALSET_EDIT, cs);
	sscanf(cs, "%i", &Iset);

	MTUSB_BLSDriverSetNormalCurrent( DevHandle, CurrentChannel, Iset );
}


void CVcExampleDlg::OnTriggerparaButton() 
{
	int CurrentChannel;
	int PulseCnt;
	int RepeatCnt;
	int Polarity;
	CString cs;
	
	int Time0;
	int Time1;
	int Time2;
	int Current0;
	int Current1;
	int Current2;

	int i;

	// TODO: Add your control notification handler code here
	GetDlgItemText(IDC_CURRENTCHANNEL_EDIT, cs);
	sscanf(cs, "%i", &CurrentChannel);

	GetDlgItemText(IDC_PulseCnt_EDIT, cs);
	sscanf(cs, "%i", &PulseCnt);

	GetDlgItemText(IDC_RepeatCnt_EDIT, cs);
	sscanf(cs, "%i", &RepeatCnt);


	GetDlgItemText(IDC_Polarity_EDIT, cs);
	sscanf(cs, "%i", &Polarity);
	Time0 = 250000;
	Time1 = 500000;
	Time2 = 250000;
	
	Current0 = 0;
	Current1 = 500;
	Current2 = 0;
	MTUSB_BLSDriverSetPulseProfile( DevHandle, CurrentChannel, Polarity, PulseCnt, RepeatCnt  );
	for ( i = 0; i <= PulseCnt-1; i++ )
	{
		MTUSB_BLSDriverSetPulseDetail( DevHandle, CurrentChannel, i, Time0, Time1, Time2, Current0, Current1, Current2);
	}
	MTUSB_BLSDriverSoftStart( DevHandle, CurrentChannel );
}

void CVcExampleDlg::OnFollowerBUTTON() 
{
	int CurrentChannel;
	int IOn;
	int IOff;
	CString cs;
	// TODO: Add your control notification handler code here

	GetDlgItemText(IDC_CURRENTCHANNEL_EDIT, cs);
	sscanf(cs, "%i", &CurrentChannel);
	
	GetDlgItemText(IDC_IOFF_EDIT, cs);
	sscanf(cs,"%i", &IOff);
	
	GetDlgItemText(IDC_ION_EDIT, cs);
	sscanf(cs,"%i",&IOn); 
	
	MTUSB_BLSDriverSetFollowModeDetail( DevHandle, CurrentChannel, IOn, IOff);
	MTUSB_BLSDriverSoftStart( DevHandle, CurrentChannel ); 
}

void CVcExampleDlg::OnSetmodeButton() 
{
	int CurrentMode;
	int CurrentChannel;
	CString cs;

	// TODO: Add your control notification handler code here
	GetDlgItemText(IDC_CURRENTCHANNEL_EDIT, cs);
	sscanf(cs, "%i", &CurrentChannel);

	if ( IsDlgButtonChecked(IDC_DISABLE_RADIO) )
		CurrentMode = 0;
	if ( IsDlgButtonChecked(IDC_NORMAL_RADIO) )
		CurrentMode = 1;
	if ( IsDlgButtonChecked(IDC_TRIGGER_RADIO) )
		CurrentMode = 3;

	MTUSB_BLSDriverSetMode( DevHandle, CurrentChannel, CurrentMode );
}

void CVcExampleDlg::OnRestDeviceBUTTON() 
{
	// TODO: Add your control notification handler code here
	MTUSB_BLSDriverResetDevice( DevHandle );
}

void CVcExampleDlg::OnStoreParaBUTTON() 
{
	// TODO: Add your control notification handler code here
	MTUSB_BLSDriverStorePara( DevHandle );
}




