import Mightex_BLSDriver_SDK as MT

""" funciton list

MT_BLSInitDevices
MT_BLSOpenDevice
MT_BLSCloseDevice
MT_BLSGetSerialNo
MT_BLSGetModuleType
MT_BLSGetChannels
MT_BLSGetChannelTitle
MT_BLSSetMode
MT_BLSSetNormalCurrent
MT_BLSSetPulseProfile
MT_BLSSetPulseDetail
MT_BLSSetFollowModeDetail
MT_BLSSoftStart
MT_BLSResetDevice
MT_BLSStorePara
MT_BLSGetEPSMCount
MT_BLSSendCommand

"""

"""
?GetChannels 


"""

usagetext = """
    === Command Usage Info ===
    close Device       - X
    get serial No.     - SN
    get module type    - Type
    get channel number - Channels
    get channel title  - Title, channelIdx
    set work mode      - Mode, channelIdx, workMode
    set normal current - Current, channelIdx, current
    set pulse profile  - Profile, channelIdx, pulseCnt, reptCnt
    set pulse detail   - Pulse, channelIdx, pulseIdx, time0, time1, time2, current0, current1, current2
    softstart          - Start, channelIdx
    reset Device       - Reset
    Send command       - CMD, commands
    print this info    - H
    e.g, to get the first channel title, enter: Title, 1
"""

moduleName = 'Mightex_BLSDriver_SDK'
devs = MT.MT_BLSInitDevices()
if  devs> 0:
    print('Devices found:' , devs)
    devHdl = MT.MT_BLSOpenDevice(0)
    
    if devHdl < 0:
        print('Open first device failed!')
    else:            
        print('First device is opened successfully!')
        print(usagetext)
        
        devChannels = 1
        cmdStr = 'SN'
        cmds = [a.rstrip() for a in cmdStr.split(',')]
        
        while(cmds[0] != 'X'):
            if(cmds[0] == 'H'):
                print(usagetext)
            if(cmds[0] == 'SN'):
                print('Device SerialNo.:',MT.MT_BLSGetSerialNo(devHdl))
            elif(cmds[0] == 'Type'):
                print('Device Type:',MT.MT_BLSGetModuleType(devHdl))
            elif(cmds[0] == 'Channels'):
                devChannels = MT.MT_BLSGetChannels(devHdl)
                print('Device channel number:', devChannels)
            elif(cmds[0] == 'Title'):
                if len(cmds) >= 2:                    
                    chnlIdx = int(cmds[1])
                    if chnlIdx in (1,devChannels + 1):
                        print(MT.MT_BLSGetChannelTitle(devHdl, chnlIdx))
                    else:
                        print('Channel index error!')
                else:
                    print('Command error!')
            elif(cmds[0] == 'Mode'):
                if len(cmds) >= 3:
                    chnlIdx = int(cmds[1])
                    mode = int(cmds[2])
                    if (chnlIdx in (1,devChannels + 1)) and (mode in [0,1,3]):
                        print('Set Mode:', MT.MT_BLSSetMode(devHdl,chnlIdx, mode))
                    else:
                        print('Unsupported parameter!')
                else:
                    print('Command error!')
            elif(cmds[0] == 'Current'): #set current
                if len(cmds) >= 3:
                    chnlIdx = int(cmds[1])
                    current = int(cmds[2])
                    if(chnlIdx in (1,devChannels + 1)) and (current >=0 ) and (current <= 1000):
                        print('Set Current: ',MT.MT_BLSSetNormalCurrent(devHdl, chnlIdx, current))
                    else:
                        print('Unsupported parameter!')
                else:
                    print('Command error!')
            elif(cmds[0] == 'Profile'): #pulse profile
                if len(cmds) >= 4:
                    chnlIdx = int(cmds[1])
                    paras = [int(cmds[i]) for  i in range(2,4)]
                    if(chnlIdx in (1,devChannels + 1)):
                        print('Set pulse profile:', MT.MT_BLSSetPulseProfile(devHdl, chnlIdx, 0, paras[0], paras[1]))
                    else:
                        print('Unsupported parameter!')
                else:
                    print('Command error!')
            elif(cmds[0] == 'Pulse'): #pulse detail
                if len(cmds) >= 9:
                    chnlIdx = int(cmds[1])
                    paras = [int(cmds[i]) for i in range(2,9)]
                    if(chnlIdx in (1,devChannels + 1)):
                        print('Set pulse detail:', MT.MT_BLSSetPulseDetail(devHdl, chnlIdx, paras[0], paras[1], paras[2], paras[3],paras[4], paras[5], paras[6]))
                    else:
                        print('Unsupported parameter!')
                else:
                    print('Command error!')
                    
            elif(cmds[0] == 'Start'):
                if len(cmds) >= 2:
                    chnlIdx = int(cmds[1])
                    if(chnlIdx in (1,devChannels + 1)):
                        print('start channel:', MT.MT_BLSSoftStart(devHdl, chnlIdx))
                    else:
                        print('Unsupported parameter!')
                else:
                    print('Command error!')
                        
            elif(cmds[0] == 'Reset'):
                print('Reset Device:', MT.MT_BLSResetDevice(devHdl))

            elif(cmds[0] == 'CMD'):
                if len(cmds) >= 2:
                    print('Send Command:', MT.MT_BLSSendCommand(devHdl, cmds[1].encode()))

            else:
                print('Unknown command!')
                
            cmdStr = input('Enter command:')
            cmds = [aStr.rstrip() for aStr in cmdStr.split(',')]
        
        print('Close Device:', MT.MT_BLSCloseDevice(devHdl))
else:
    print('Device not found')