unit Example;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Datatypes, DllInterface, StdCtrls, ExtCtrls, RzPanel, RzRadGrp;

type
  TForm1 = class(TForm)
    InitButton: TButton;
    InitDeviceEdit: TEdit;
    OpenDeviceButton: TButton;
    GetSerialNoButton: TButton;
    SerialNoEdit: TEdit;
    GetChannelButton: TButton;
    ChannelNoEdit: TEdit;
    GroupBox1: TGroupBox;
    ResetButton: TButton;
    StoreButton: TButton;
    GroupBox2: TGroupBox;
    INormalSetEdit: TEdit;
    NormalSetButton: TButton;
    CloseButton: TButton;
    GroupBox4: TGroupBox;
    PulseCountEdit: TEdit;
    PolarityEdit: TEdit;
    TriggerSetButton: TButton;
    Label1: TLabel;
    CurrentChannelEdit: TEdit;
    ChannelModeGroup: TRadioGroup;
    CloseDeviceButton: TButton;
    RepeatCountEdit: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    GroupBox3: TGroupBox;
    IOffEdit: TEdit;
    IONEdit: TEdit;
    BtnSetFollowMode: TButton;
    Label6: TLabel;
    Label7: TLabel;
    SetModeButton: TButton;
    procedure CloseButtonClick(Sender: TObject);
    procedure InitButtonClick(Sender: TObject);
    procedure OpenDeviceButtonClick(Sender: TObject);
    procedure GetSerialNoButtonClick(Sender: TObject);
    procedure GetChannelButtonClick(Sender: TObject);
    procedure SetModeButtonClick(Sender: TObject);
    procedure ResetButtonClick(Sender: TObject);
    procedure NormalSetButtonClick(Sender: TObject);
    procedure TriggerSetButtonClick(Sender: TObject);
    procedure CloseDeviceButtonClick(Sender: TObject);
    procedure BtnSetFollowModeClick(Sender: TObject);
    procedure StoreButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  DevHandle : integer;

implementation

{$R *.DFM}

procedure TForm1.InitButtonClick(Sender: TObject);
var
  Devices : integer;
begin
  Devices := MTUSB_BLSDriverInitDevices();
  InitDeviceEdit.Text := IntToStr( Devices );
end;

procedure TForm1.OpenDeviceButtonClick(Sender: TObject);
begin
  DevHandle :=   MTUSB_BLSDriverOpenDevice( 0 );
end;

procedure TForm1.CloseDeviceButtonClick(Sender: TObject);
begin
  MTUSB_BLSDriverCloseDevice( DevHandle );
end;


procedure TForm1.GetSerialNoButtonClick(Sender: TObject);
var
  SerialNo : Array[0..31] of AnsiChar;
begin
  MTUSB_BLSDriverGetSerialNo( DevHandle, @SerialNo[0], sizeof( SerialNo ) );
  SerialNoEdit.Text := String( SerialNo );
end;

procedure TForm1.GetChannelButtonClick(Sender: TObject);
var
  Channel : integer;
begin
  Channel := MTUSB_BLSDriverGetChannels( DevHandle );
  ChannelNoEdit.Text := IntToStr( Channel );
end;

procedure TForm1.SetModeButtonClick(Sender: TObject);
var
  Channel : integer;
  Mode : integer;
begin
  Channel := StrToInt( CurrentChannelEdit.Text );

  Mode := ChannelModeGroup.ItemIndex;
  if Mode = 2  then
    Mode := 3;
    
  MTUSB_BLSDriverSetMode( DevHandle, Channel, Mode );
end;

procedure TForm1.NormalSetButtonClick(Sender: TObject);
var
  Channel : integer;
  i : integer;
  NormalCurrent : Integer;
begin

  Channel := StrToInt( CurrentChannelEdit.Text );
  NormalCurrent := StrToInt( INormalSetEdit.Text );
  MTUSB_BLSDriverSetNormalCurrent( DevHandle, Channel, NormalCurrent );
//  MTUSB_BLSDriverSoftStart( DevHandle, Channel );
end;

procedure TForm1.TriggerSetButtonClick(Sender: TObject);
var
  I: Integer;
  Channel : integer;
  Polarity : Integer;
  PuleCnt : Integer;
  RepeatCnt : integer;

begin
  Channel := StrToInt( CurrentChannelEdit.Text );
  Polarity := StrToInt( PolarityEdit.Text );
  PuleCnt  := StrToInt( PulseCountEdit.Text);
  RepeatCnt := StrToInt( RepeatCountEdit.Text );
  MTUSB_BLSDriverSetPulseProfile( DevHandle, Channel, Polarity, PuleCnt, RepeatCnt  );
  for I := 0 to PuleCnt - 1 do    // Iterate
  begin
    MTUSB_BLSDriverSetPulseDetail( DevHandle, Channel, I, 
                                   Timing[0], Timing[1], Timing[2],
                                   Current[0], Current[1], Current[2] );
  end;    // for

  MTUSB_BLSDriverSoftStart( DevHandle, Channel);
end;

procedure TForm1.BtnSetFollowModeClick(Sender: TObject);
var
  Channel : Integer;
  Ioff : integer;
  IOn  : integer;
begin
  Channel := StrToInt( CurrentChannelEdit.Text );
  IOff := StrToInt( IOffEdit.Text ) ;
  IOn := StrToInt( IOnEdit.Text ) ;
  MTUSB_BLSDriverSetFollowModeDetail( DevHandle, Channel, IOn, IOff);
  MTUSB_BLSDriverSoftStart( DevHandle, Channel );
end;

procedure TForm1.ResetButtonClick(Sender: TObject);
begin
  MTUSB_BLSDriverResetDevice( DevHandle );
end;

procedure TForm1.StoreButtonClick(Sender: TObject);
begin
  MTUSB_BLSDriverStorePara( DevHandle );
end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
  MTUSB_BLSDriverSetMode( DevHandle, 88, 0);
  MTUSB_BLSDriverCloseDevice( DevHandle );
  Close;
end;

end.
