using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace MTBLSDriver
{
    public partial class Form1 : Form
    {
        private cBLSDriver BLSDriverEg;
        private int _numDrivers;
        private int channelIndex;

        public Form1()
        {
            InitializeComponent();
            BLSDriverEg = new cBLSDriver(this);
            _numDrivers = 0;
        }

        private void GetSerialNobutton_Click(object sender, EventArgs e)
        {
            LabelSerialNo.Text = BLSDriverEg.GetSerialNo();
        }

        private void Openbutton_Click(object sender, EventArgs e)
        {
            if (_numDrivers > 0)
                BLSDriverEg.OpenDevice(0); // Open the first device
        }


        private void btnInit_Click(object sender, EventArgs e)
        {
            _numDrivers = BLSDriverEg.InitDevice();
            LabelDeviceCnt.Text = "Total Drivers: " + _numDrivers.ToString();
        }


        private void ChannelNum_ValueChanged(object sender, EventArgs e)
        {
            channelIndex = (int)ChannelNum.Value - 1;
        }


        private void btnSetNormal_Click(object sender, EventArgs e)
        {
            int current;
            
            current = int.Parse(EditCurrent.Text) * 10;
            if (channelIndex >= 0)
                BLSDriverEg.SetNormalCurrent(channelIndex, current);
        }

        private void btnGetChannel_Click(object sender, EventArgs e)
        {
            int channelCnt;
            channelCnt = BLSDriverEg.GetChannelNumber();
            LabelChannels.Text = "Channels: " + channelCnt.ToString();
            if (channelCnt > 0)
            {
                ChannelNum.Minimum = 1;
                ChannelNum.Maximum = channelCnt;
            }
            else
            {
                ChannelNum.Maximum = 0;
                ChannelNum.Minimum = 0;
            }
            ChannelNum.Value = ChannelNum.Minimum;
            channelIndex = (int)ChannelNum.Value - 1;
        }

        private void btnSetPulse_Click(object sender, EventArgs e)
        {
            int pulseCnt, reptCnt, polarity;
            int i;
            pulseCnt = int.Parse(EditPulseCount.Text);
            reptCnt = int.Parse(EditRepeatCount.Text);
            polarity = int.Parse(EditPolarity.Text);

            if (channelIndex >= 0)
            {
                BLSDriverEg.SetPulseProfile(channelIndex, polarity, pulseCnt, reptCnt);
                for(i=0; i<pulseCnt;i++)
                {
                    BLSDriverEg.SetPulseDetail(channelIndex, i);
                }
                BLSDriverEg.SoftStart(channelIndex);
            }

        }

        private void btnSetFollowerDetail_Click(object sender, EventArgs e)
        {
            int IOn, IOff;
            IOn = int.Parse(EditIOn.Text);
            IOff = int.Parse(EditIOff.Text);
            if (channelIndex >= 0)
            {
                BLSDriverEg.SetFollowModeDetail(channelIndex, IOn, IOff);
            }
        }

        private void btnSetMode_Click(object sender, EventArgs e)
        {
            int wMode;
            if (rbtnDisabled.Checked)
                wMode = 0;
            else if (rbtnNormal.Checked)
                wMode = 1;
            else if (rbtnTrigger.Checked)
                wMode = 3;
            else
                wMode = 0;
            
            if (channelIndex >= 0)
            {
                BLSDriverEg.SetChannelMode(channelIndex, wMode);
            }

        }

        private void btnReset_Click(object sender, EventArgs e)
        {

            BLSDriverEg.Reset();
        }

        private void btnStore_Click(object sender, EventArgs e)
        {
            BLSDriverEg.StorePara();
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            BLSDriverEg.CloseDevice();
        }


   
    }
}