using System;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Xml;
using System.Xml.Serialization;

//*****Open issue remains with bool values always being set to true even after cam initialized.
// Timer doesn't seem to work to show images continually, will need to implement the Mightex Hooker callback
// if we want direct updates to the windows form.

namespace MTBLSDriver
{

    public class cBLSDriver
    {
        //Members...
        public enum WORK_MODE {DISABLE = 0, NORMAL=1, TRIGGER = 3};

        private uint _devHandle = 99;

        private string _drvError = "BLS Driver Error";
        

        //default constructor for testing
        public cBLSDriver(Form1 MTBLSDriver)
        {

        }

         /// <summary>
        /// Call this function first, this function communicates with device driver to reserve resources
        /// </summary>
        /// <returns>number of cameras on USB 2.0 chan</returns>
        public int InitDevice()
        {
            int numBLSDriver = MTUSB_BLSDriverInitDevices();

            if (numBLSDriver < 0)
            {
                MessageBox.Show("Error trying to initialize sources. No drivers found on USB 2.0 bus.", _drvError, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            return numBLSDriver;
        }
        
        public void OpenDevice(int deviceID)
        {
            _devHandle = MTUSB_BLSDriverOpenDevice(deviceID);
        }

        public void CloseDevice()
        {
            MTUSB_BLSDriverCloseDevice(_devHandle);
        }

        public string GetSerialNo()
        {
            string moduleNumber = "Unknown";
            StringBuilder rtnStr = new StringBuilder(32);

            if (MTUSB_BLSDriverGetSerialNo(_devHandle, rtnStr, 32) < 0)
            {
                MessageBox.Show("Error trying to retrieve module number.", _drvError, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                moduleNumber = rtnStr.ToString();
            }
            return moduleNumber;
        }

        public int GetChannelNumber()
        {
            int chl_no;

            chl_no = MTUSB_BLSDriverGetChannels(_devHandle);
            return chl_no;
        }


        public int SetChannelMode( int channel, int workMode)
        {

            return (MTUSB_BLSDriverSetMode(_devHandle, (uint)channel, (uint)workMode));
        }

        public int SetNormalCurrent(int channel, int CurrentbyuA)
        {
            return MTUSB_BLSDriverSetNormalCurrent(_devHandle, (uint)channel, (uint)CurrentbyuA);
        }

        public int SetPulseProfile(int channel, int polarity, int pulseCnt, int reptCnt)
        {
            return MTUSB_BLSDriverSetPulseProfile(_devHandle, (uint)channel, (uint)polarity, (uint)pulseCnt, (uint)reptCnt);
        }

        public int SetPulseDetail(int channel, int pulseIndex)
        {
            uint time0, time1, time2;
            uint Current0, Current1, Current2;

            time0 = 250000;
            time1 = 500000;
            time2 = 250000;

            Current0 = 0;
            Current1 = 500;
            Current2 = 0;

            return MTUSB_BLSDriverSetPulseDetail(_devHandle, (uint)channel, (uint)pulseIndex, time0, time1, time2, Current0, Current1, Current2);

        }

        public int SetFollowModeDetail(int channel, int ION, int IOFF)
        {

            return MTUSB_BLSDriverSetFollowModeDetail(_devHandle, (uint)channel, (uint)ION, (uint)IOFF);
        }

        public int SoftStart(int channel)
        {
            return MTUSB_BLSDriverSoftStart(_devHandle, (uint)channel);
        }

        public int Reset()
        {
            return MTUSB_BLSDriverResetDevice(_devHandle);
        }

        public int StorePara()
        {
            return MTUSB_BLSDriverStorePara(_devHandle);
        }
        #region Mightex interop functions for accessing Mightex_LEDDriver_SDK_Stdcall.dll file
  
        //Call this function first, this function communicates with device driver to reserve resources
        //When the system uses NTFS use WINNT, for FAT32 use WINDOWS

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverInitDevices", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverInitDevices();

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverOpenDevice", CallingConvention = CallingConvention.StdCall)]
        private static extern uint MTUSB_BLSDriverOpenDevice(int deviceID);

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverCloseDevice", CallingConvention = CallingConvention.StdCall)]
        private static extern uint MTUSB_BLSDriverCloseDevice(uint devHandle);

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverGetSerialNo", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverGetSerialNo(uint devHandle, StringBuilder moduleNo, uint size);

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverGetChannels", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverGetChannels(uint devHandle);

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverSetMode", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverSetMode(uint devHandle, uint channel, uint mode);

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverSetNormalCurrent", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverSetNormalCurrent(uint devHandle, uint channel, uint current);

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverSetPulseProfile", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverSetPulseProfile(uint devHandle, uint channel, uint polarity, uint pulseCnt, uint reptCnt);

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverSetPulseDetail", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverSetPulseDetail(uint devHandle, uint channel,uint pulseIndex, uint Time0, uint Time1, uint Time2, uint Curr0, uint Curr1, uint Curr2);
        
        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverSetFollowModeDetail", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverSetFollowModeDetail(uint devHandle, uint channel, uint ION, uint IOFF);

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverSoftStart", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverSoftStart(uint devHandle, uint channel);

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverResetDevice", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverResetDevice(uint DevHandle);

        [DllImport("Mightex_BLSDriver_SDK_stdcall.dll", EntryPoint = "MTUSB_BLSDriverStorePara", CallingConvention = CallingConvention.StdCall)]
        private static extern int MTUSB_BLSDriverStorePara(uint devHandle);


        #endregion
    }

}
