using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace LEDDriver
{
    public partial class Form1 : Form
    {
        private CLEDDriver myLEDDriver; // = new CCameraUSB( this );
        private int _numDrivers;

        public Form1()
        {
            InitializeComponent();
            myLEDDriver = new CLEDDriver(this);

            _numDrivers = myLEDDriver.InitDevice();
            DriverLabel.Text = "Total Drivers: " + _numDrivers.ToString();
        }

        private void OKButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void GetSerialNobutton_Click(object sender, EventArgs e)
        {
            SerialNotextBox.Text = myLEDDriver.GetSerialNo();
        }

        private void Openbutton_Click(object sender, EventArgs e)
        {
            if (_numDrivers > 0)
                myLEDDriver.OpenDevice(0); // Open the first device
        }

        private void SetNormalbutton_Click(object sender, EventArgs e)
        {
            int channelno;

            channelno = (int)ChannelNum.Value;
            myLEDDriver.LedChannelData.Normal_CurrentMax = 200;
            myLEDDriver.LedChannelData.Normal_CurrentSet = 50;
            myLEDDriver.SetNormalPara(channelno);
        }

        private void SetStrobebutton_Click(object sender, EventArgs e)
        {
            int channelno;

            channelno = (int)ChannelNum.Value;
 
            myLEDDriver.LedChannelData.Strobe_CurrentMax = 200;
            myLEDDriver.LedChannelData.Strobe_RepeatCnt = 1;
            myLEDDriver.SetStrobeProfileData(0, 50);   // Current (50mA) for first step
            myLEDDriver.SetStrobeProfileData(1, 1000); // Time (1ms) for first step
            myLEDDriver.SetStrobeProfileData(2, 20);   // Current (20mA) for second step
            myLEDDriver.SetStrobeProfileData(3,10000); // Time (10ms) for second step
            myLEDDriver.SetStrobeProfileData(4, 0);
            myLEDDriver.SetStrobeProfileData(5, 0);    // end of profile
            myLEDDriver.SetStrobePara(channelno);
        }

        private void SetTriggerbutton_Click(object sender, EventArgs e)
        {
            int channelno;

            channelno = (int)ChannelNum.Value;
            myLEDDriver.LedChannelData.Trigger_CurrentMax = 200;
            myLEDDriver.LedChannelData.Trigger_Polarity = 0;
            myLEDDriver.SetTriggerProfileData(0, 50);   // Current (50mA) for first step
            myLEDDriver.SetTriggerProfileData(1, 1000); // Time (1ms) for first step
            myLEDDriver.SetTriggerProfileData(2, 20);   // Current (20mA) for second step
            myLEDDriver.SetTriggerProfileData(3, 10000); // Time (10ms) for second step
            myLEDDriver.SetTriggerProfileData(4, 0);
            myLEDDriver.SetTriggerProfileData(5, 0);    // end of profile
            myLEDDriver.SetTriggerPara(channelno);
        }

        private void SetModebutton_Click(object sender, EventArgs e)
        {
            int channelno;

            channelno = (int)ChannelNum.Value;

            // For example, we set the channel to DISABLE mode
            myLEDDriver.SetChannelMode(channelno, CLEDDriver.WORK_MODE.DISABLE);
        }

        private void Closebutton_Click(object sender, EventArgs e)
        {
            myLEDDriver.CloseDevice();
        }

   
    }
}